/*
 * This script contains the language-specific data used by searchtools.js,
 * namely the set of stopwords, stemmer, scorer and splitter.
 */

const stopwords = new Set(["alla", "allt", "att", "av", "blev", "bli", "blir", "blivit", "de", "dem", "den", "denna", "deras", "dess", "dessa", "det", "detta", "dig", "din", "dina", "ditt", "du", "d\u00e4r", "d\u00e5", "efter", "ej", "eller", "en", "er", "era", "ert", "ett", "fr\u00e5n", "f\u00f6r", "ha", "hade", "han", "hans", "har", "henne", "hennes", "hon", "honom", "hur", "h\u00e4r", "i", "icke", "ingen", "inom", "inte", "jag", "ju", "kan", "kunde", "man", "med", "mellan", "men", "mig", "min", "mina", "mitt", "mot", "mycket", "ni", "nu", "n\u00e4r", "n\u00e5gon", "n\u00e5got", "n\u00e5gra", "och", "om", "oss", "p\u00e5", "samma", "sedan", "sig", "sin", "sina", "sitta", "sj\u00e4lv", "skulle", "som", "s\u00e5", "s\u00e5dan", "s\u00e5dana", "s\u00e5dant", "till", "under", "upp", "ut", "utan", "vad", "var", "vara", "varf\u00f6r", "varit", "varje", "vars", "vart", "vem", "vi", "vid", "vilka", "vilkas", "vilken", "vilket", "v\u00e5r", "v\u00e5ra", "v\u00e5rt", "\u00e4n", "\u00e4r", "\u00e5t", "\u00f6ver"]);
window.stopwords = stopwords;  // Export to global scope


/* Non-minified versions are copied as separate JavaScript files, if available */
BaseStemmer=function(){this.current="",this.cursor=0,this.limit=0,this.limit_backward=0,this.bra=0,this.ket=0,this.setCurrent=function(t){this.current=t,this.cursor=0,this.limit=this.current.length,this.limit_backward=0,this.bra=this.cursor,this.ket=this.limit},this.getCurrent=function(){return this.current},this.copy_from=function(t){this.current=t.current,this.cursor=t.cursor,this.limit=t.limit,this.limit_backward=t.limit_backward,this.bra=t.bra,this.ket=t.ket},this.in_grouping=function(t,r,i){return!(this.cursor>=this.limit||i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor++,0))},this.go_in_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.in_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward||i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i))||(this.cursor--,0))},this.go_in_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(i<s||s<r)return!0;if(0==(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.out_grouping=function(t,r,i){return!(this.cursor>=this.limit)&&(i<(i=this.current.charCodeAt(this.cursor))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor++,!0)},this.go_out_grouping=function(t,r,i){for(;this.cursor<this.limit;){var s=this.current.charCodeAt(this.cursor);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor++}return!1},this.out_grouping_b=function(t,r,i){return!(this.cursor<=this.limit_backward)&&(i<(i=this.current.charCodeAt(this.cursor-1))||i<r||0==(t[(i-=r)>>>3]&1<<(7&i)))&&(this.cursor--,!0)},this.go_out_grouping_b=function(t,r,i){for(;this.cursor>this.limit_backward;){var s=this.current.charCodeAt(this.cursor-1);if(s<=i&&r<=s&&0!=(t[(s-=r)>>>3]&1<<(7&s)))return!0;this.cursor--}return!1},this.eq_s=function(t){return!(this.limit-this.cursor<t.length||this.current.slice(this.cursor,this.cursor+t.length)!=t||(this.cursor+=t.length,0))},this.eq_s_b=function(t){return!(this.cursor-this.limit_backward<t.length||this.current.slice(this.cursor-t.length,this.cursor)!=t||(this.cursor-=t.length,0))},this.find_among=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit,e=0,n=0,c=!1;;){for(var u=r+(i-r>>>1),o=0,a=e<n?e:n,l=t[u],f=a;f<l[0].length;f++){if(s+a==h){o=-1;break}if(0!=(o=this.current.charCodeAt(s+a)-l[0].charCodeAt(f)))break;a++}if(o<0?(i=u,n=a):(r=u,e=a),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(l=t[r])[0].length){if(this.cursor=s+l[0].length,l.length<4)return l[2];var g=l[3](this);if(this.cursor=s+l[0].length,g)return l[2]}}while(0<=(r=l[1]));return 0},this.find_among_b=function(t){for(var r=0,i=t.length,s=this.cursor,h=this.limit_backward,e=0,n=0,c=!1;;){for(var u,o=r+(i-r>>1),a=0,l=e<n?e:n,f=(u=t[o])[0].length-1-l;0<=f;f--){if(s-l==h){a=-1;break}if(0!=(a=this.current.charCodeAt(s-1-l)-u[0].charCodeAt(f)))break;l++}if(a<0?(i=o,n=l):(r=o,e=l),i-r<=1){if(0<r)break;if(i==r)break;if(c)break;c=!0}}do{if(e>=(u=t[r])[0].length){if(this.cursor=s-u[0].length,u.length<4)return u[2];var g=u[3](this);if(this.cursor=s-u[0].length,g)return u[2]}}while(0<=(r=u[1]));return 0},this.replace_s=function(t,r,i){var s=i.length-(r-t);return this.current=this.current.slice(0,t)+i+this.current.slice(r),this.limit+=s,this.cursor>=r?this.cursor+=s:this.cursor>t&&(this.cursor=t),s},this.slice_check=function(){return!(this.bra<0||this.bra>this.ket||this.ket>this.limit||this.limit>this.current.length)},this.slice_from=function(t){var r=!1;return this.slice_check()&&(this.replace_s(this.bra,this.ket,t),r=!0),r},this.slice_del=function(){return this.slice_from("")},this.insert=function(t,r,i){r=this.replace_s(t,r,i);t<=this.bra&&(this.bra+=r),t<=this.ket&&(this.ket+=r)},this.slice_to=function(){var t="";return t=this.slice_check()?this.current.slice(this.bra,this.ket):t},this.assign_to=function(){return this.current.slice(0,this.limit)}};
var SwedishStemmer=function(){var a=new BaseStemmer,i=[["fab",-1,-1],["h",-1,-1],["pak",-1,-1],["rak",-1,-1],["stak",-1,-1],["kom",-1,-1],["iet",-1,-1],["cit",-1,-1],["dit",-1,-1],["alit",-1,-1],["ilit",-1,-1],["mit",-1,-1],["nit",-1,-1],["pit",-1,-1],["rit",-1,-1],["sit",-1,-1],["tit",-1,-1],["uit",-1,-1],["ivit",-1,-1],["kvit",-1,-1],["xit",-1,-1]],e=[["a",-1,1],["arna",0,1],["erna",0,1],["heterna",2,1],["orna",0,1],["ad",-1,1],["e",-1,1],["ade",6,1],["ande",6,1],["arne",6,1],["are",6,1],["aste",6,1],["en",-1,1],["anden",12,1],["aren",12,1],["heten",12,1],["ern",-1,1],["ar",-1,1],["er",-1,1],["heter",18,1],["or",-1,1],["s",-1,2],["as",21,1],["arnas",22,1],["ernas",22,1],["ornas",22,1],["es",21,1],["ades",26,1],["andes",26,1],["ens",21,1],["arens",29,1],["hetens",29,1],["erns",21,1],["at",-1,1],["et",-1,3],["andet",34,1],["het",34,1],["ast",-1,1]],s=[["dd",-1,-1],["gd",-1,-1],["nn",-1,-1],["dt",-1,-1],["gt",-1,-1],["kt",-1,-1],["tt",-1,-1]],c=[["ig",-1,1],["lig",0,1],["els",-1,1],["fullt",-1,3],["öst",-1,2]],u=[17,65,16,1,0,0,0,0,0,0,0,0,0,0,0,0,24,0,32],o=[119,127,149],n=[173,58],l=0,m=0;function _(){var r=a.limit-a.cursor;if(a.out_grouping_b(u,97,246)&&(a.in_grouping_b(u,97,246)&&a.cursor>a.limit_backward))return a.cursor=a.limit-r,r=a.limit-a.cursor,0==a.find_among_b(i)?(a.cursor=a.limit-r,1):void 0}this.stem=function(){var r=a.cursor,i=(m=a.limit,t=a.cursor,(i=a.cursor+3)>a.limit||(a.cursor=i,l=a.cursor,a.cursor=t,a.go_out_grouping(u,97,246)&&(a.cursor++,a.go_in_grouping(u,97,246))&&(a.cursor++,m=a.cursor,l<=m||(m=l))),a.cursor=r,a.limit_backward=a.cursor,a.cursor=a.limit,a.limit-a.cursor),t=((()=>{var r;if(!(a.cursor<m)){var i=a.limit_backward;if(a.limit_backward=m,a.ket=a.cursor,0==(r=a.find_among_b(e)))a.limit_backward=i;else switch(a.bra=a.cursor,a.limit_backward=i,r){case 1:if(a.slice_del())break;return;case 2:var t=a.limit-a.cursor;if(a.eq_s_b("et")&&_())a.bra=a.cursor;else if(a.cursor=a.limit-t,!a.in_grouping_b(o,98,121))return;if(a.slice_del())break;return;case 3:if(!_())return;if(a.slice_del())break}}})(),a.cursor=a.limit-i,a.limit-a.cursor),i=(a.cursor<m||(r=a.limit_backward,a.limit_backward=m,i=a.limit-a.cursor,(0==a.find_among_b(s)||(a.cursor=a.limit-i,a.ket=a.cursor,a.cursor<=a.limit_backward)||(a.cursor--,a.bra=a.cursor,a.slice_del()))&&(a.limit_backward=r)),a.cursor=a.limit-t,a.limit-a.cursor);return(()=>{var r;if(!(a.cursor<m)){var i=a.limit_backward;if(a.limit_backward=m,a.ket=a.cursor,0==(r=a.find_among_b(c)))a.limit_backward=i;else switch(a.bra=a.cursor,a.limit_backward=i,r){case 1:if(a.slice_del())break;return;case 2:if(!a.in_grouping_b(n,105,118))return;if(a.slice_from("ös"))break;return;case 3:if(a.slice_from("full"))break}}})(),a.cursor=a.limit-i,a.cursor=a.limit_backward,!0},this.stemWord=function(r){return a.setCurrent(r),this.stem(),a.getCurrent()}};
window.Stemmer = SwedishStemmer;
